CONTAINER fx_fluidobj
{
	NAME fx_fluidobj;
	INCLUDE Obase;
	GROUP
	{
		SEPARATOR {LINE;}

		LONG FLUIDOBJ_PRESETS
		{
			CYCLE
			{
				FLUIDOBJ_PRESETS_DEFAULT;
			}
		}
		GROUP
		{
		COLUMNS 4;
		BUTTON FLUIDOBJ_PRESETS_SET {}
		BUTTON FLUIDOBJ_PRESETS_SAVE {}
		BUTTON FLUIDOBJ_PRESETS_SAVEAS {}
		BUTTON FLUIDOBJ_PRESETS_DE {}
		}
	}	
	GROUP ID_OBJECTPROPERTIES
	{
		DEFAULT 1;
		LINK FLUIDOBJ_FSSROOT {ACCEPT{Obase;}}
		LONG FLUIDOBJ_TYPE
		{
			CYCLE
			{
				FLUIDOBJ_TYPE_SOURCE;
				FLUIDOBJ_TYPE_OBSTACLE;
				FLUIDOBJ_TYPE_EVENTHANDLER;
			}
		}
		BOOL FLUIDOBJ_RETURNOBJECT {}

		SEPARATOR{LINE;}

		LONG FLUIDOBJ_SHAPE
		{
			CYCLE
			{
				FLUID_BOX;
				FLUID_SPHERE;
				FLUID_ELLIPSOID;
				FLUID_TORUS;
				FLUID_TUBE;
				FLUID_CONE;
				//FLUID_PLANE;
				//FLUID_SPLINE;
				FLUID_MESH;
			}
			ANIM OFF;
		}
		
		LINK FLUIDOBJ_MESHLINK {ACCEPT{Obase;};}
		LINK FLUIDOBJ_SELECTION {ACCEPT{Tpolygonselection;};}

		REAL FLUIDOBJ_RADIUS {MIN 0.001; UNIT METER; }
		VECTOR FLUIDOBJ_OBJSIZE {MIN 0.001 0.001 0.001; UNIT METER;HIDDEN;}
		REAL FLUIDOBJ_INNERRAD {MIN 0; MAX 100.0; UNIT PERCENT;}
		BOOL FLUIDOBJ_INVERTRAD {}
		LONG FLUIDOBJ_FLUIDSAMPLEEXTENT { MIN 2; ANIM OFF;}
		GROUP ID_FLUIDOBJ_MESH_G
		{	
			LONG FLUIDOBJ_MESH_VOXELISER { CYCLE { FLUIDOBJ_MESH_VOXELISER_SIMPLE; FLUIDOBJ_MESH_VOXELISER_COMPLEX; } }
			BOOL FLUIDOBJ_MESH_AAFILTER {HIDDEN;}
			REAL FLUIDOBJ_MESH_THICKNESS {MIN 0; MAX 100; STEP 0.1; }
			REAL FLUIDOBJ_MESH_FILTERWIDTH {MIN 0; MAX 100;  STEP 0.1; }

			LONG FLUIDOBJ_LEVELSETQUALITY {MIN 1; MAX 10; }
			BOOL FLUIDOBJ_SAFESWEEP {}
		}

		SEPARATOR {LINE;}

		REAL FLUIDOBJ_OBSTACLE_LINEARSTRENGTH { MIN 0; MAX 100; STEP 0.01; }
		REAL FLUIDOBJ_OBSTACLE_ANGULARSTRENGTH { MIN 0; MAX 100; STEP 0.01; }
	}
	GROUP SID_FLUIDOBJ_EVENTS
	{
		LONG FLUIDOBJ_EVENTTYPE
		{
			CYCLE 
			{
			FLUIDOBJ_EVENTTYPE_INSIDE;
			FLUIDOBJ_EVENTTYPE_OBJECTDISTANCE;
			FLUIDOBJ_EVENTTYPE_EMITTERDISTANCE;
			FLUIDOBJ_EVENTTYPE_VOXELDISTANCE;
			FLUIDOBJ_EVENTTYPE_POSOFFSET;
			FLUIDOBJ_EVENTTYPE_SCALE;
			FLUIDOBJ_EVENTTYPE_CUSTOM;
			}
		}
		//INSIDE & DENSITYRATIO
		LONG FLUIDOBJ_EVENTCHANNEL
		{
			CYCLE
			{
				FLUIDOBJ_EVENTCHANNEL_SMOKE;
				FLUIDOBJ_EVENTCHANNEL_TEMP;
				FLUIDOBJ_EVENTCHANNEL_FIRE;
				FLUIDOBJ_EVENTCHANNEL_FUEL;
				FLUIDOBJ_EVENTCHANNEL_COLOR;
				FLUIDOBJ_EVENTCHANNEL_SPEED;
			}
		}
		//Channels Threshold
		REAL FLUIDOBJ_EVENT_THRESHOLD {MIN 0.001; MAX 100; UNIT PERCENT;}
		//Object Distance & Offset
		REAL FLUIDOBJ_EVENT_RATIOMAX {MIN 0.001; UNIT METER;}
		//Custom
		REAL FLUIDOBJ_EVENT_CUSTOM {MIN 0; UNIT PERCENT;}
		//Object Distance & Offset
		LINK FLUIDOBJ_EVENT_OBJECT {ACCEPT{Obase;}}
		BOOL FLUIDOBJ_EVENT_INVERT {}
	}
	GROUP SID_FLUIDOBJ_SOURCES
	{
		REAL FLUIDOBJ_EMISSION_FPS {MIN 1; MAX 50000;}
		LONG FLUIDOBJ_EMISSION_SIMSUBSTEPS {MIN 0;}

		LONG FLUIDOBJ_EMISSION_SUBSTEPS {MIN 1; MAX 10000;}
		REAL FLUIDOBJ_EMISSION_SUBSTEPS_LENGTH {MIN 0; UNIT METER;}
		LINK FLUIDOBJ_MESH_TEXTAG {ACCEPT{Ttexture;}}
		GROUP SID_FLUIDOBJ_SMOKE
		{
			DEFAULT 1;
			LONG FLUIDOBJ_SMOKE_ABSOLUTE 
			{
				CYCLE
				{
				FLUIDOBJ_SMOKE_ABSOLUTE_RATE;
				FLUIDOBJ_SMOKE_ABSOLUTE_SET;
				FLUIDOBJ_SMOKE_ABSOLUTE_LIMIT;
				}
			}
			REAL FLUIDOBJ_SMOKE_LIMIT {STEP 0.001; MAX 100.0;} 
			BOOL FLUIDOBJ_SIMSPACE_SMOKE {}
			REAL FLUIDOBJ_OBJSOURCERATE {STEP 0.001; MAX 100.0;} 
			SEPARATOR {LINE;}
			LONG FLUIDOBJ_SMOKE_TIMER_LENGTH {MIN 0;}
			LONG FLUIDOBJ_SMOKE_TIMER_START {MIN 0;}
			
			SPLINE FLUIDOBJ_SMOKE_TIMER_INTENSITY
			{
				SHOWGRID_H; 
													  
				X_MIN 0; 
				X_MAX 1; 
									  
				Y_MIN 0; 
				Y_MAX 1; 
									  
				X_STEPS 0.01; 
				Y_STEPS 0.01; 
			}
			SEPARATOR {LINE;}
			LONG FLUIDOBJ_SMOKE_FALLOFFMODE
			{
				CYCLE
				{
					FLUIDOBJ_SMOKE_FALLOFFMODE_CONST;
					FLUIDOBJ_SMOKE_FALLOFFMODE_LINEAR;
					FLUIDOBJ_SMOKE_FALLOFFMODE_SPLINE;
				}
			}
			SPLINE FLUIDOBJ_SMOKE_FALLOFF
			{
				SHOWGRID_H; 
													  
				X_MIN 0; 
				X_MAX 1; 
									  
				Y_MIN 0; 
				Y_MAX 1; 
									  
				X_STEPS 0.01; 
				Y_STEPS 0.01; 
			}
			LONG FLUIDOBJ_SMOKE_TTCHANNEL
			{
				CYCLE
				{
				FLUIDOBJ_SMOKE_TTCHANNEL_NONE;
				FLUIDOBJ_SMOKE_TTCHANNEL_COLOR;
				FLUIDOBJ_SMOKE_TTCHANNEL_LUMINANCE;
				FLUIDOBJ_SMOKE_TTCHANNEL_TRANSPARENCY;
				FLUIDOBJ_SMOKE_TTCHANNEL_REFLECTION;
				FLUIDOBJ_SMOKE_TTCHANNEL_ENVIRONMENT;
				FLUIDOBJ_SMOKE_TTCHANNEL_FOG;
				FLUIDOBJ_SMOKE_TTCHANNEL_BUMP;
				FLUIDOBJ_SMOKE_TTCHANNEL_ALPHA;
				FLUIDOBJ_SMOKE_TTCHANNEL_DISPLACEMENT;
				FLUIDOBJ_SMOKE_TTCHANNEL_DIFFUSION;
				FLUIDOBJ_SMOKE_TTCHANNEL_NORMAL;
				}
			}
			
			LONG FLUIDOBJ_SMOKEEVENT
			{
				CYCLE
				{
					FLUIDOBJ_SMOKEEVENT_NONE;
					FLUIDOBJ_SMOKEEVENT_CHANNELS;
				}
			}
			LONG FLUIDOBJ_SMOKEEVENTCHANNEL
			{
				CYCLE
				{
					//FLUIDOBJ_SMOKEEVENTCHANNEL_SMOKE;
					FLUIDOBJ_SMOKEEVENTCHANNEL_TEMP;
					FLUIDOBJ_SMOKEEVENTCHANNEL_FIRE;
					FLUIDOBJ_SMOKEEVENTCHANNEL_FUEL;
					FLUIDOBJ_SMOKEEVENTCHANNEL_COLOR;
					FLUIDOBJ_SMOKEEVENTCHANNEL_SPEED;
				}
			}
			SEPARATOR {LINE;}
			GROUP
			{
				LAYOUTGROUP; COLUMNS 2;
				GROUP
				{
					BITMAPBUTTON FLUIDOBJ_NOISE_DPREVIEW {BORDER;}
				}
				GROUP
				{
					REAL FLUIDOBJ_NOISE_D {MIN 0.0; STEP 0.5;}
					LONG FLUIDOBJ_NOISE_TYPESMOKE
					{
						CYCLE
						{					
						}
					}
					REAL FLUIDOBJ_NOISE_DC {MIN 0.0; MAX 1000; UNIT PERCENT;}
					REAL FLUIDOBJ_NOISE_DVELO {MIN 0.0; UNIT PERCENT;}
				}
			}
		}	
		GROUP SID_FLUIDOBJ_HEAT
		{
			DEFAULT 0;
			LONG FLUIDOBJ_SIMSPACE_HEAT 
			{
				CYCLE
				{
				FLUIDOBJ_SIMSPACE_HEAT_RATE;
				FLUIDOBJ_SIMSPACE_HEAT_SET;
				FLUIDOBJ_SIMSPACE_HEAT_LIMIT;
				}
			}
			REAL FLUIDOBJ_HEAT_LIMIT {STEP 0.001; MAX 5000;} 
			BOOL FLUIDOBJ_HEATPERFRAME {}
			BOOL FLUIDOBJ_FIRE_ATMAX {}
			REAL FLUIDOBJ_TEMPERATURE {STEP 0.001; MIN -5000; MAX 5000;}
			SEPARATOR {LINE;}
			LONG FLUIDOBJ_HEAT_TIMER_LENGTH {MIN 0;}
			LONG FLUIDOBJ_HEAT_TIMER_START {MIN 0;}
			
			SPLINE FLUIDOBJ_HEAT_TIMER_INTENSITY
			{
				SHOWGRID_H; 
													  
				X_MIN 0; 
				X_MAX 1; 
									  
				Y_MIN 0; 
				Y_MAX 1; 
									  
				X_STEPS 0.01; 
				Y_STEPS 0.01; 
			}
			SEPARATOR {LINE;}
			LONG FLUIDOBJ_HEAT_FALLOFFMODE
			{
				CYCLE
				{
					FLUIDOBJ_SMOKE_FALLOFFMODE_CONST;
					FLUIDOBJ_SMOKE_FALLOFFMODE_LINEAR;
					FLUIDOBJ_SMOKE_FALLOFFMODE_SPLINE;
				}
			}
			SPLINE FLUIDOBJ_HEAT_FALLOFF
			{
				SHOWGRID_H; 
													  
				X_MIN 0; 
				X_MAX 1; 
									  
				Y_MIN 0; 
				Y_MAX 1; 
									  
				X_STEPS 0.01; 
				Y_STEPS 0.01; 
			}
			LONG FLUIDOBJ_HEAT_TTCHANNEL
			{
				CYCLE
				{
				FLUIDOBJ_HEAT_TTCHANNEL_NONE;
				FLUIDOBJ_HEAT_TTCHANNEL_COLOR;
				FLUIDOBJ_HEAT_TTCHANNEL_LUMINANCE;
				FLUIDOBJ_HEAT_TTCHANNEL_TRANSPARENCY;
				FLUIDOBJ_HEAT_TTCHANNEL_REFLECTION;
				FLUIDOBJ_HEAT_TTCHANNEL_ENVIRONMENT;
				FLUIDOBJ_HEAT_TTCHANNEL_FOG;
				FLUIDOBJ_HEAT_TTCHANNEL_BUMP;
				FLUIDOBJ_HEAT_TTCHANNEL_ALPHA;
				FLUIDOBJ_HEAT_TTCHANNEL_DISPLACEMENT;
				FLUIDOBJ_HEAT_TTCHANNEL_DIFFUSION;
				FLUIDOBJ_HEAT_TTCHANNEL_NORMAL;
				}
			}
			LONG FLUIDOBJ_HEATEVENT
			{
				CYCLE
				{
					FLUIDOBJ_HEATEVENT_NONE;
					FLUIDOBJ_HEATEVENT_CHANNELS;
				}
			}
			LONG FLUIDOBJ_HEATEVENTCHANNEL
			{
				CYCLE
				{
					FLUIDOBJ_HEATEVENTCHANNEL_SMOKE;
					//FLUIDOBJ_HEATEVENTCHANNEL_TEMP;
					FLUIDOBJ_HEATEVENTCHANNEL_FIRE;
					FLUIDOBJ_HEATEVENTCHANNEL_FUEL;
					FLUIDOBJ_HEATEVENTCHANNEL_COLOR;
					FLUIDOBJ_HEATEVENTCHANNEL_SPEED;
				}
			}
			SEPARATOR {LINE;}
			GROUP
			{
				LAYOUTGROUP; COLUMNS 2;
				GROUP
				{
					BITMAPBUTTON FLUIDOBJ_NOISE_TPREVIEW {BORDER;}
				}
				GROUP
				{
					REAL FLUIDOBJ_NOISE_T {MIN 0.0; STEP 0.5;}
					LONG FLUIDOBJ_NOISE_TYPEHEAT
					{
						CYCLE
						{					
						}
					}
					REAL FLUIDOBJ_NOISE_TC {MIN 0.0; MAX 1000; UNIT PERCENT;}	
					REAL FLUIDOBJ_NOISE_TVELO {MIN 0.0; UNIT PERCENT;}
				}
			}
		}
		GROUP SID_FLUIDOBJ_FUEL
		{
			DEFAULT 0;
			LONG FLUIDOBJ_FUEL_ABSOLUTE 
			{
				CYCLE
				{
				FLUIDOBJ_FUEL_ABSOLUTE_RATE;
				FLUIDOBJ_FUEL_ABSOLUTE_SET;
				FLUIDOBJ_FUEL_ABSOLUTE_LIMIT;
				}
			}
			REAL FLUIDOBJ_FUEL_LIMIT {STEP 0.001; MAX 1.0;} 
			BOOL FLUIDOBJ_SIMSPACE_FUEL {}
			REAL FLUIDOBJ_FUEL {MIN 0; MAX 1.0f; STEP 0.001;}
			SEPARATOR {LINE;}
			LONG FLUIDOBJ_FUEL_TIMER_LENGTH {MIN 0;}
			LONG FLUIDOBJ_FUEL_TIMER_START {MIN 0;}
			
			SPLINE FLUIDOBJ_FUEL_TIMER_INTENSITY
			{
				SHOWGRID_H; 
													  
				X_MIN 0; 
				X_MAX 1; 
									  
				Y_MIN 0; 
				Y_MAX 1; 
									  
				X_STEPS 0.01; 
				Y_STEPS 0.01; 
			}
			SEPARATOR {LINE;}
			LONG FLUIDOBJ_FUEL_FALLOFFMODE
			{
				CYCLE
				{
					FLUIDOBJ_SMOKE_FALLOFFMODE_CONST;
					FLUIDOBJ_SMOKE_FALLOFFMODE_LINEAR;
					FLUIDOBJ_SMOKE_FALLOFFMODE_SPLINE;
				}
			}
			SPLINE FLUIDOBJ_FUEL_FALLOFF
			{
				SHOWGRID_H; 
													  
				X_MIN 0; 
				X_MAX 1; 
									  
				Y_MIN 0; 
				Y_MAX 1; 
									  
				X_STEPS 0.01; 
				Y_STEPS 0.01; 
			}
			LONG FLUIDOBJ_FUEL_TTCHANNEL
			{
				CYCLE
				{
				FLUIDOBJ_FUEL_TTCHANNEL_NONE;
				FLUIDOBJ_FUEL_TTCHANNEL_COLOR;
				FLUIDOBJ_FUEL_TTCHANNEL_LUMINANCE;
				FLUIDOBJ_FUEL_TTCHANNEL_TRANSPARENCY;
				FLUIDOBJ_FUEL_TTCHANNEL_REFLECTION;
				FLUIDOBJ_FUEL_TTCHANNEL_ENVIRONMENT;
				FLUIDOBJ_FUEL_TTCHANNEL_FOG;
				FLUIDOBJ_FUEL_TTCHANNEL_BUMP;
				FLUIDOBJ_FUEL_TTCHANNEL_ALPHA;
				FLUIDOBJ_FUEL_TTCHANNEL_DISPLACEMENT;
				FLUIDOBJ_FUEL_TTCHANNEL_DIFFUSION;
				FLUIDOBJ_FUEL_TTCHANNEL_NORMAL;
				}
			}
			LONG FLUIDOBJ_FUELEVENT
			{
				CYCLE
				{
					FLUIDOBJ_FUELEVENT_NONE;
					FLUIDOBJ_FUELEVENT_CHANNELS;
				}
			}
			LONG FLUIDOBJ_FUELEVENTCHANNEL
			{
				CYCLE
				{
					FLUIDOBJ_FUELEVENTCHANNEL_SMOKE;
					FLUIDOBJ_FUELEVENTCHANNEL_TEMP;
					FLUIDOBJ_FUELEVENTCHANNEL_FIRE;
					//FLUIDOBJ_FUELEVENTCHANNEL_FUEL;
					FLUIDOBJ_FUELEVENTCHANNEL_COLOR;
					FLUIDOBJ_FUELEVENTCHANNEL_SPEED;
				}
			}			
			SEPARATOR {LINE;}
			GROUP
			{
				LAYOUTGROUP; COLUMNS 2;
				GROUP
				{
					BITMAPBUTTON FLUIDOBJ_NOISE_FPREVIEW {BORDER;}
				}
				GROUP
				{
					REAL FLUIDOBJ_NOISE_F {MIN 0.0; STEP 0.5;}
					LONG FLUIDOBJ_NOISE_TYPEFUEL
					{
						CYCLE
						{					
						}
					}
					REAL FLUIDOBJ_NOISE_FC {MIN 0.0; MAX 1000; UNIT PERCENT;}	
					REAL FLUIDOBJ_NOISE_FVELO {MIN 0.0; UNIT PERCENT;}
				}
			}
		}
		GROUP SID_FLUIDOBJ_PRESSURE
		{
			DEFAULT 0;
			REAL FLUIDOBJ_PRESSURE {STEP 0.001;}
			SEPARATOR {LINE;}
			LONG FLUIDOBJ_PRESSURE_TIMER_LENGTH {MIN 0;}
			LONG FLUIDOBJ_PRESSURE_TIMER_START {MIN 0;}
			
			SPLINE FLUIDOBJ_PRESSURE_TIMER_INTENSITY
			{
				SHOWGRID_H; 
													  
				X_MIN 0; 
				X_MAX 1; 
									  
				Y_MIN 0; 
				Y_MAX 1; 
									  
				X_STEPS 0.01; 
				Y_STEPS 0.01; 
			}
			SEPARATOR {LINE;}
			LONG FLUIDOBJ_PRESSURE_FALLOFFMODE
			{
				CYCLE
				{
					FLUIDOBJ_SMOKE_FALLOFFMODE_CONST;
					FLUIDOBJ_SMOKE_FALLOFFMODE_LINEAR;
					FLUIDOBJ_SMOKE_FALLOFFMODE_SPLINE;
				}
			}
			SPLINE FLUIDOBJ_PRESSURE_FALLOFF
			{
				SHOWGRID_H; 
													  
				X_MIN 0; 
				X_MAX 1; 
									  
				Y_MIN 0; 
				Y_MAX 1; 
									  
				X_STEPS 0.01; 
				Y_STEPS 0.01; 
			}
			LONG FLUIDOBJ_PRESSUREEVENT 
			{
				CYCLE
				{
					FLUIDOBJ_PRESSUREEVENT_NONE;
					FLUIDOBJ_PRESSUREEVENT_CHANNELS;
				}
			}
			LONG FLUIDOBJ_PRESSUREEVENTCHANNEL
			{
				CYCLE
				{
					FLUIDOBJ_PRESSUREEVENTCHANNEL_SMOKE;
					FLUIDOBJ_PRESSUREEVENTCHANNEL_TEMP;
					FLUIDOBJ_PRESSUREEVENTCHANNEL_FIRE;
					FLUIDOBJ_PRESSUREEVENTCHANNEL_FUEL;
					FLUIDOBJ_PRESSUREEVENTCHANNEL_COLOR;
					FLUIDOBJ_PRESSUREEVENTCHANNEL_SPEED;
				}
			}
			SEPARATOR {LINE;}
			GROUP
			{
				LAYOUTGROUP; COLUMNS 2;
				GROUP
				{
					BITMAPBUTTON FLUIDOBJ_NOISE_PPREVIEW {BORDER;}
				}
				GROUP
				{
					REAL FLUIDOBJ_NOISE_P {MIN 0.0; STEP 0.5;}
					LONG FLUIDOBJ_NOISE_TYPEPRESSURE
					{
						CYCLE
						{					
						}
					}
					REAL FLUIDOBJ_NOISE_PC {MIN 0.0; MAX 1000; UNIT PERCENT;}	
					REAL FLUIDOBJ_NOISE_PVELO {MIN 0.0; UNIT PERCENT;}
				}
			}
		}	
		GROUP SID_FLUIDOBJ_COLOR
		{
			DEFAULT 0;
			LONG FLUIDOBJ_COLOR_ABSOLUTE
			{
				CYCLE
				{
				FLUIDOBJ_COLOR_ABSOLUTE_RATE;
				FLUIDOBJ_COLOR_ABSOLUTE_SET;
				FLUIDOBJ_COLOR_ABSOLUTE_LIMIT;
				}
			}
			COLOR FLUIDOBJ_COLOR_LIMIT {}
			BOOL FLUIDOBJ_COLORPERFRAME {}
			COLOR FLUIDOBJ_COLOR {}
			SEPARATOR {LINE;}
			LONG FLUIDOBJ_COLOR_TIMER_LENGTH {MIN 0;}
			LONG FLUIDOBJ_COLOR_TIMER_START {MIN 0;}
			
			SPLINE FLUIDOBJ_COLOR_TIMER_INTENSITY
			{
				SHOWGRID_H; 
													  
				X_MIN 0; 
				X_MAX 1; 
									  
				Y_MIN 0; 
				Y_MAX 1; 
									  
				X_STEPS 0.01; 
				Y_STEPS 0.01; 
			}
			SEPARATOR {LINE;}
			LONG FLUIDOBJ_COLOR_FALLOFFMODE
			{
				CYCLE
				{
					FLUIDOBJ_SMOKE_FALLOFFMODE_CONST;
					FLUIDOBJ_SMOKE_FALLOFFMODE_LINEAR;
					FLUIDOBJ_SMOKE_FALLOFFMODE_SPLINE;
				}
			}
			SPLINE FLUIDOBJ_COLOR_FALLOFF
			{
				SHOWGRID_H; 
													  
				X_MIN 0; 
				X_MAX 1; 
									  
				Y_MIN 0; 
				Y_MAX 1; 
									  
				X_STEPS 0.01; 
				Y_STEPS 0.01; 
			}
			LONG FLUIDOBJ_COLOR_TTCHANNEL
			{
				CYCLE
				{
				FLUIDOBJ_COLOR_TTCHANNEL_NONE;
				FLUIDOBJ_COLOR_TTCHANNEL_COLOR;
				FLUIDOBJ_COLOR_TTCHANNEL_LUMINANCE;
				FLUIDOBJ_COLOR_TTCHANNEL_TRANSPARENCY;
				FLUIDOBJ_COLOR_TTCHANNEL_REFLECTION;
				FLUIDOBJ_COLOR_TTCHANNEL_ENVIRONMENT;
				FLUIDOBJ_COLOR_TTCHANNEL_FOG;
				FLUIDOBJ_COLOR_TTCHANNEL_BUMP;
				FLUIDOBJ_COLOR_TTCHANNEL_ALPHA;
				FLUIDOBJ_COLOR_TTCHANNEL_DISPLACEMENT;
				FLUIDOBJ_COLOR_TTCHANNEL_DIFFUSION;
				FLUIDOBJ_COLOR_TTCHANNEL_NORMAL;
				}
			}
			LONG FLUIDOBJ_COLOREVENT
			{
				CYCLE
				{
					FLUIDOBJ_COLOREVENT_NONE;
					FLUIDOBJ_COLOREVENT_CHANNELS;
				}
			}
			LONG FLUIDOBJ_COLOREVENTCHANNEL
			{
				CYCLE
				{
					FLUIDOBJ_COLOREVENTCHANNEL_SMOKE;
					FLUIDOBJ_COLOREVENTCHANNEL_TEMP;
					FLUIDOBJ_COLOREVENTCHANNEL_FIRE;
					FLUIDOBJ_COLOREVENTCHANNEL_FUEL;
					//FLUIDOBJ_COLOREVENTCHANNEL_COLOR;
					FLUIDOBJ_COLOREVENTCHANNEL_SPEED;
				}
			}
			
			SEPARATOR {LINE;}
			GROUP
			{
				LAYOUTGROUP; COLUMNS 2;
				GROUP
				{
					BITMAPBUTTON FLUIDOBJ_NOISE_CPREVIEW {BORDER;}
				}
				GROUP
				{
					REAL FLUIDOBJ_NOISE_C {MIN 0.0; STEP 0.5;}
					LONG FLUIDOBJ_NOISE_TYPECOLOR
					{
						CYCLE
						{					
						}
					}
					REAL FLUIDOBJ_NOISE_CC {MIN 0.0; MAX 1000; UNIT PERCENT;}	
					REAL FLUIDOBJ_NOISE_CVELO {MIN 0.0; UNIT PERCENT;}
					GRADIENT FLUIDOBJ_NOISE_C_GRAD {COLOR; ANIM ON;}
				}
			}
		}
		GROUP ID_FLUIDOBJ_WIND_G
		{
			LONG FLUIDOBJ_SIMSPACE 
			{
				CYCLE
				{
				FLUIDOBJ_SIMSPACE_RATE;
				FLUIDOBJ_SIMSPACE_SET;
				FLUIDOBJ_SIMSPACE_LIMIT;
				}
			}
			REAL FLUIDOBJ_WIND_LIMIT {MIN -10000; MAX 10000; STEP 0.1;}	
			REAL FLUIDOBJ_FORCE_STRENGTH {MIN -10000; MAX 10000; STEP 0.1;}	
			SEPARATOR {LINE;}
			LONG FLUIDOBJ_WIND_TIMER_LENGTH {MIN 0;}
			LONG FLUIDOBJ_WIND_TIMER_START {MIN 0;}
			
			SPLINE FLUIDOBJ_WIND_TIMER_INTENSITY
			{
				SHOWGRID_H; 
													  
				X_MIN 0; 
				X_MAX 1; 
									  
				Y_MIN 0; 
				Y_MAX 1; 
									  
				X_STEPS 0.01; 
				Y_STEPS 0.01; 
			}
			SEPARATOR {LINE;}
			LONG FLUIDOBJ_WIND_FALLOFFMODE
			{
				CYCLE
				{
					FLUIDOBJ_SMOKE_FALLOFFMODE_CONST;
					FLUIDOBJ_SMOKE_FALLOFFMODE_LINEAR;
					FLUIDOBJ_SMOKE_FALLOFFMODE_SPLINE;
				}
			}
			SPLINE FLUIDOBJ_WIND_FALLOFF
			{
				SHOWGRID_H; 
													  
				X_MIN 0; 
				X_MAX 1; 
									  
				Y_MIN 0; 
				Y_MAX 1; 
									  
				X_STEPS 0.01; 
				Y_STEPS 0.01; 
			}		
			LONG FLUIDOBJ_FORCE
			{
				CYCLE
				{			
					FLUIDOBJ_FORCE_CUSTOM_X;
					FLUIDOBJ_FORCE_CUSTOM;
					FLUIDOBJ_FORCE_CUSTOM_Z;
					FLUIDOBJ_FORCE_SPHERICAL;
					FLUIDOBJ_FORCE_CYLINDRICAL;
					FLUIDOBJ_FORCE_CUSTOMDIR;
					FLUIDOBJ_FORCE_TURBULENCE;					
					FLUIDOBJ_FORCE_NORMAL;
				}
			}
			LINK FLUIDOBJ_CUSTOMWINDOBJ {ACCEPT{Obase;}}
			LONG FLUIDOBJ_WINDEVENT
			{
				CYCLE
				{
					FLUIDOBJ_WINDEVENT_NONE;
					FLUIDOBJ_WINDEVENT_CHANNELS;
				}
			}
			LONG FLUIDOBJ_WINDEVENTCHANNEL
			{
				CYCLE
				{
					FLUIDOBJ_WINDEVENTCHANNEL_SMOKE;
					FLUIDOBJ_WINDEVENTCHANNEL_TEMP;
					FLUIDOBJ_WINDEVENTCHANNEL_FIRE;
					FLUIDOBJ_WINDEVENTCHANNEL_FUEL;
					FLUIDOBJ_WINDEVENTCHANNEL_COLOR;
					FLUIDOBJ_WINDEVENTCHANNEL_SPEED;
				}
			}
			
			SEPARATOR {LINE;}
			GROUP
			{
				LAYOUTGROUP; COLUMNS 2;
				GROUP
				{
					BITMAPBUTTON FLUIDOBJ_NOISE_WPREVIEW {BORDER;}
				}
				GROUP
				{
					REAL FLUIDOBJ_NOISE_W {MIN 0.0; STEP 0.5;}
					LONG FLUIDOBJ_NOISE_TYPE 
					{
						CYCLE
						{					
						}
					}
					REAL FLUIDOBJ_NOISE_WC {MIN 0.0; MAX 1000; UNIT PERCENT;}
					REAL FLUIDOBJ_NOISE_WVELO {MIN 0.0; UNIT PERCENT;}
				}
			}
		}
		GROUP ID_FLUIDOBJ_VORTEX_G
		{		
			LONG FLUIDOBJ_SUBGRIDLAYER 
			{
				CYCLE
				{	
					FLUIDOBJ_SUBGRIDLAYER_PARENT;
				}
			}
			LONG FLUIDOBJ_VORTEX_ALIGN
			{
				CYCLE
				{
					FLUIDOBJ_VORTEX_ALIGN_X;
					FLUIDOBJ_VORTEX_ALIGN_Y;
					FLUIDOBJ_VORTEX_ALIGN_Z;
					FLUIDOBJ_VORTEX_ALIGN_SPHERICAL;
					FLUIDOBJ_VORTEX_ALIGN_BOX;
					FLUIDOBJ_VORTEX_ALIGN_CYLINDRICAL;
					FLUIDOBJ_VORTEX_ALIGN_RANDOM;
					FLUIDOBJ_VORTEX_ALIGN_XYZ;
					FLUIDOBJ_VORTEX_ALIGN_NORMAL;
				}
			}
			BOOL FLUIDOBJ_VORTEX_ALIGN_INVERT {}
			VECTOR FLUIDOBJ_VORTEX_XYZ {MIN -1 -1 -1; MAX 1 1 1; STEP 0.001;}

			SEPARATOR {LINE;}
			LONG FLUIDOBJ_VORTEXEVENT
			{
				CYCLE
				{
					FLUIDOBJ_VORTEXEVENT_NONE;
					FLUIDOBJ_VORTEXEVENT_CHANNELS;
				}
			}
			LONG FLUIDOBJ_VORTEXEVENTCHANNEL
			{
				CYCLE
				{
					FLUIDOBJ_VORTEXEVENTCHANNEL_SMOKE;
					FLUIDOBJ_VORTEXEVENTCHANNEL_TEMP;
					FLUIDOBJ_VORTEXEVENTCHANNEL_FIRE;
					FLUIDOBJ_VORTEXEVENTCHANNEL_FUEL;
					FLUIDOBJ_VORTEXEVENTCHANNEL_COLOR;
					FLUIDOBJ_VORTEXEVENTCHANNEL_SPEED;
				}
			}
			GROUP
			{
				COLUMNS 2;
				LONG FLUIDOBJ_VORTEX_SAMPLES {MIN 0;}
				SEPARATOR {}

				LONG FLUIDOBJ_VORTEX_AGE {MIN 1;}
				REAL FLUIDOBJ_VORTEX_AGEVAR {MIN 0; MAX 100; UNIT PERCENT;}

				REAL FLUIDOBJ_VORTEX_RADIUS { MIN 0.0; MAX 5000.0; STEP 0.01;}	
				REAL FLUIDOBJ_VORTEX_RADIUSVAR {MIN 0.0; MAX 100.0; UNIT PERCENT;}
			}
			
			SEPARATOR {LINE;}
			LONG FLUIDOBJ_VP_TIMER_LENGTH {MIN 0;}
			LONG FLUIDOBJ_VP_TIMER_START {MIN 0;}
			
			SPLINE FLUIDOBJ_VP_TIMER_INTENSITY
			{
				SHOWGRID_H; 
													  
				X_MIN 0; 
				X_MAX 1; 
									  
				Y_MIN 0; 
				Y_MAX 1; 
									  
				X_STEPS 0.01; 
				Y_STEPS 0.01; 
			}
			SEPARATOR {LINE;}
			SHADERLINK FLUIDOBJ_VORTEX_EMISSIONSHADER {}
			REAL FLUIDOBJ_VORTEX_EMISSIONSHADER_DELTA_A {MIN 0; MAX 100; UNIT PERCENT;}
			REAL FLUIDOBJ_VORTEX_EMISSIONSHADER_DELTA_B {MIN 0; MAX 100; UNIT PERCENT;}
		}
		GROUP ID_FLUIDOBJ_FLUIDPARTICLES_G
		{		
			BOOL FLUIDOBJ_INJECT_FLUIDPARTICLES {}
			LONG FLUIDOBJ_FLUIDGROUP
			{
				CYCLE
				{
					FLUIDOBJ_FLUIDGROUP_ALL;
				}
			}

			SEPARATOR{}

			LONG FLUIDOBJ_FP_ALIGN
			{
				CYCLE
				{
					FLUIDOBJ_FP_ALIGN_X;
					FLUIDOBJ_FP_ALIGN_Y;
					FLUIDOBJ_FP_ALIGN_Z;
					FLUIDOBJ_FP_ALIGN_SPHERICAL;
					FLUIDOBJ_FP_ALIGN_BOX;
					FLUIDOBJ_FP_ALIGN_CYLINDRICAL;
					FLUIDOBJ_FP_ALIGN_RANDOM;
					FLUIDOBJ_FP_ALIGN_XYZ;
					FLUIDOBJ_FP_ALIGN_NORMAL;
				}
			}
			BOOL FLUIDOBJ_FP_ALIGN_INVERT {}
			VECTOR FLUIDOBJ_FP_XYZ {MIN -1 -1 -1; MAX 1 1 1; STEP 0.001;}

			SEPARATOR {LINE;}

			LONG FLUIDOBJ_FPEVENT
			{
				CYCLE
				{
					FLUIDOBJ_FPEVENT_NONE;
					FLUIDOBJ_FPEVENT_CHANNELS;
				}
			}
			LONG FLUIDOBJ_FPEVENTCHANNEL
			{
				CYCLE
				{
					FLUIDOBJ_FPEVENTCHANNEL_SMOKE;
					FLUIDOBJ_FPEVENTCHANNEL_TEMP;
					FLUIDOBJ_FPEVENTCHANNEL_FIRE;
					FLUIDOBJ_FPEVENTCHANNEL_FUEL;
					FLUIDOBJ_FPEVENTCHANNEL_COLOR;
					FLUIDOBJ_FPEVENTCHANNEL_SPEED;
				}
			}
			GROUP
			{
				COLUMNS 2;
				
				LONG FLUIDOBJ_FP_SAMPLES {MIN 0;}
				LONG FLUIDOBJ_FP_TTCHANNEL
				{
					CYCLE
					{
					FLUIDOBJ_FP_TTCHANNEL_NONE;
					FLUIDOBJ_FP_TTCHANNEL_COLOR;
					FLUIDOBJ_FP_TTCHANNEL_LUMINANCE;
					FLUIDOBJ_FP_TTCHANNEL_TRANSPARENCY;
					FLUIDOBJ_FP_TTCHANNEL_REFLECTION;
					FLUIDOBJ_FP_TTCHANNEL_ENVIRONMENT;
					FLUIDOBJ_FP_TTCHANNEL_FOG;
					FLUIDOBJ_FP_TTCHANNEL_BUMP;
					FLUIDOBJ_FP_TTCHANNEL_ALPHA;
					FLUIDOBJ_FP_TTCHANNEL_DISPLACEMENT;
					FLUIDOBJ_FP_TTCHANNEL_DIFFUSION;
					FLUIDOBJ_FP_TTCHANNEL_NORMAL;
					}
				}
			}
			SEPARATOR {LINE;}
			LONG FLUIDOBJ_FP_TIMER_LENGTH {MIN 0;}
			LONG FLUIDOBJ_FP_TIMER_START {MIN 0;}
			
			SPLINE FLUIDOBJ_FP_TIMER_INTENSITY
			{
				SHOWGRID_H; 
													  
				X_MIN 0; 
				X_MAX 1; 
									  
				Y_MIN 0; 
				Y_MAX 1; 
									  
				X_STEPS 0.01; 
				Y_STEPS 0.01; 
			}
			SEPARATOR {LINE;}
			GROUP
			{
				COLUMNS 2;
				LONG FLUIDOBJ_FP_AGE {MIN 1;}
				REAL FLUIDOBJ_FP_AGEVAR {MIN 0; MAX 100; UNIT PERCENT;}

				REAL FLUIDOBJ_FP_RADIUS { MIN 0.0; MAX 5000.0; STEP 0.01; UNIT METER;}	
				REAL FLUIDOBJ_FP_RADIUSVAR {MIN 0.0; MAX 100.0; UNIT PERCENT;}

				REAL FLUIDOBJ_FP_SMOKE {MIN 0; STEP 0.001;}
				REAL FLUIDOBJ_FP_HEAT {MIN 0; MAX 5000;}
				REAL FLUIDOBJ_FP_FUEL {MIN 0; }
				REAL FLUIDOBJ_FP_PRESSURE {STEP 0.001;}
				COLOR FLUIDOBJ_FP_COLOR {}
				LONG FLUIDOBJ_FP_TTCHANNELCOL
				{
					CYCLE
					{
					FLUIDOBJ_FP_TTCHANNELCOL_NONE;
					FLUIDOBJ_FP_TTCHANNELCOL_COLOR;
					FLUIDOBJ_FP_TTCHANNELCOL_LUMINANCE;
					FLUIDOBJ_FP_TTCHANNELCOL_TRANSPARENCY;
					FLUIDOBJ_FP_TTCHANNELCOL_REFLECTION;
					FLUIDOBJ_FP_TTCHANNELCOL_ENVIRONMENT;
					FLUIDOBJ_FP_TTCHANNELCOL_FOG;
					FLUIDOBJ_FP_TTCHANNELCOL_BUMP;
					FLUIDOBJ_FP_TTCHANNELCOL_ALPHA;
					FLUIDOBJ_FP_TTCHANNELCOL_DISPLACEMENT;
					FLUIDOBJ_FP_TTCHANNELCOL_DIFFUSION;
					FLUIDOBJ_FP_TTCHANNELCOL_NORMAL;
					}
				}
			}
		}
		
		GROUP ID_FLUIDOBJ_WATERPARTICLES_G
		{		
			BOOL FLUIDOBJ_WATER_SAMPLES {}
			LONG FLUIDOBJ_WATER_FLUIDGROUP
			{
				CYCLE
				{
					FLUIDOBJ_WATER_FLUIDGROUP_ALL;
				}
			}
			LONG FLUIDOBJ_WATER_MCNT {MIN 0; MAX 50; HIDDEN;}
			REAL FLUIDOBJ_WATER_JITTER {MIN 0; MAX 100.0; UNIT PERCENT;}

			SEPARATOR {LINE;}
			LONG FLUIDOBJ_WATER_AGE {MIN 1;}
			REAL FLUIDOBJ_WATER_RADIUS {MIN 0.01; MAX 10.0; STEP 0.01;}
			REAL FLUIDOBJ_WATER_VISCOSITY {MIN 0.001; }
			REAL FLUIDOBJ_WATER_DENSITY {MIN 0.001; MAX 100000.0;}
			COLOR FLUIDOBJ_WATER_COLOR { }
			SEPARATOR {LINE;}
			
			LONG FLUIDOBJ_WATEREVENT
			{
				CYCLE
				{
					FLUIDOBJ_WATEREVENT_NONE;
					FLUIDOBJ_WATEREVENT_CHANNELS;
				}
			}
			LONG FLUIDOBJ_WATEREVENTCHANNEL
			{
				CYCLE
				{
					FLUIDOBJ_WATEREVENTCHANNEL_SMOKE;
					FLUIDOBJ_WATEREVENTCHANNEL_TEMP;
					FLUIDOBJ_WATEREVENTCHANNEL_FIRE;
					FLUIDOBJ_WATEREVENTCHANNEL_FUEL;
					FLUIDOBJ_WATEREVENTCHANNEL_COLOR;
					FLUIDOBJ_WATEREVENTCHANNEL_SPEED;
				}
			}
			SEPARATOR {LINE;}
			LONG FLUIDOBJ_WATER_TIMER_LENGTH {MIN 0;}
			LONG FLUIDOBJ_WATER_TIMER_START {MIN 0;}

			SEPARATOR {LINE;}
			
			GROUP
			{
				LAYOUTGROUP; COLUMNS 2;
				GROUP
				{
					BITMAPBUTTON FLUIDOBJ_NOISE_WATERPREVIEW {BORDER;}
				}
				GROUP
				{
					REAL FLUIDOBJ_NOISE_WATER {MIN 0.0; STEP 0.5;}
					LONG FLUIDOBJ_NOISE_WATERTYPE 
					{
						CYCLE
						{					
						}
					}
					REAL FLUIDOBJ_NOISE_WATERC {MIN 0.0; MAX 1000; UNIT PERCENT;}
					REAL FLUIDOBJ_NOISE_WATERVELO {MIN 0.0; UNIT PERCENT;}
				}
			}
		}
	}
	GROUP ID_FLUIDOBJ_SPLINE_G
	{	
		REAL FLUIDOBJ_SPLINEMIN {MIN 0; MAX 100; UNIT PERCENT; }
		REAL FLUIDOBJ_SPLINEMAX {MIN 0; MAX 100; UNIT PERCENT; }		
	}
}